Imports System.Runtime.Remoting.Messaging

Public Class Entry
    Inherits System.Windows.Forms.Form

#Region " Windows Form Designer generated code "

    Public Sub New()
        MyBase.New()

        'This call is required by the Windows Form Designer.
        InitializeComponent()

        'Add any initialization after the InitializeComponent() call

    End Sub

    'Form overrides dispose to clean up the component list.
    Protected Overloads Overrides Sub Dispose(ByVal disposing As Boolean)
        If disposing Then
            If Not (components Is Nothing) Then
                components.Dispose()
            End If
        End If
        MyBase.Dispose(disposing)
    End Sub
    Friend WithEvents GroupBox1 As System.Windows.Forms.GroupBox
    Friend WithEvents Label1 As System.Windows.Forms.Label
    Friend WithEvents Employee As System.Windows.Forms.Label
    Friend WithEvents Label2 As System.Windows.Forms.Label
    Friend WithEvents Button1 As System.Windows.Forms.Button
    Friend WithEvents Button2 As System.Windows.Forms.Button
    Friend WithEvents StartDate As System.Windows.Forms.TextBox
    Friend WithEvents Label3 As System.Windows.Forms.Label
    Friend WithEvents EndDate As System.Windows.Forms.TextBox
    Friend WithEvents TimeGrid As System.Windows.Forms.DataGrid

    'Required by the Windows Form Designer
    Private components As System.ComponentModel.Container

    'NOTE: The following procedure is required by the Windows Form Designer
    'It can be modified using the Windows Form Designer.  
    'Do not modify it using the code editor.
    <System.Diagnostics.DebuggerStepThrough()> Private Sub InitializeComponent()
        Me.GroupBox1 = New System.Windows.Forms.GroupBox()
        Me.EndDate = New System.Windows.Forms.TextBox()
        Me.Label3 = New System.Windows.Forms.Label()
        Me.StartDate = New System.Windows.Forms.TextBox()
        Me.Label2 = New System.Windows.Forms.Label()
        Me.Employee = New System.Windows.Forms.Label()
        Me.Label1 = New System.Windows.Forms.Label()
        Me.Button1 = New System.Windows.Forms.Button()
        Me.Button2 = New System.Windows.Forms.Button()
        Me.TimeGrid = New System.Windows.Forms.DataGrid()
        Me.GroupBox1.SuspendLayout()
        CType(Me.TimeGrid, System.ComponentModel.ISupportInitialize).BeginInit()
        Me.SuspendLayout()
        '
        'GroupBox1
        '
        Me.GroupBox1.Controls.AddRange(New System.Windows.Forms.Control() {Me.EndDate, Me.Label3, Me.StartDate, Me.Label2, Me.Employee, Me.Label1})
        Me.GroupBox1.Location = New System.Drawing.Point(8, 8)
        Me.GroupBox1.Name = "GroupBox1"
        Me.GroupBox1.Size = New System.Drawing.Size(528, 56)
        Me.GroupBox1.TabIndex = 0
        Me.GroupBox1.TabStop = False
        Me.GroupBox1.Text = "Outlook parameters:"
        '
        'EndDate
        '
        Me.EndDate.Location = New System.Drawing.Point(416, 24)
        Me.EndDate.Name = "EndDate"
        Me.EndDate.TabIndex = 5
        Me.EndDate.Text = "txtEndDate"
        '
        'Label3
        '
        Me.Label3.Location = New System.Drawing.Point(360, 24)
        Me.Label3.Name = "Label3"
        Me.Label3.Size = New System.Drawing.Size(56, 23)
        Me.Label3.TabIndex = 4
        Me.Label3.Text = "End date:"
        Me.Label3.TextAlign = System.Drawing.ContentAlignment.MiddleLeft
        '
        'StartDate
        '
        Me.StartDate.Location = New System.Drawing.Point(240, 24)
        Me.StartDate.Name = "StartDate"
        Me.StartDate.TabIndex = 3
        Me.StartDate.Text = "txtStartDate"
        '
        'Label2
        '
        Me.Label2.Location = New System.Drawing.Point(184, 24)
        Me.Label2.Name = "Label2"
        Me.Label2.Size = New System.Drawing.Size(56, 24)
        Me.Label2.TabIndex = 2
        Me.Label2.Text = "Start date:"
        Me.Label2.TextAlign = System.Drawing.ContentAlignment.MiddleLeft
        '
        'Employee
        '
        Me.Employee.Location = New System.Drawing.Point(72, 24)
        Me.Employee.Name = "Employee"
        Me.Employee.Size = New System.Drawing.Size(100, 24)
        Me.Employee.TabIndex = 1
        Me.Employee.Text = "lblEmployee"
        Me.Employee.TextAlign = System.Drawing.ContentAlignment.MiddleLeft
        '
        'Label1
        '
        Me.Label1.Location = New System.Drawing.Point(8, 24)
        Me.Label1.Name = "Label1"
        Me.Label1.Size = New System.Drawing.Size(64, 24)
        Me.Label1.TabIndex = 0
        Me.Label1.Text = "Employee:"
        Me.Label1.TextAlign = System.Drawing.ContentAlignment.MiddleLeft
        '
        'Button1
        '
        Me.Button1.Location = New System.Drawing.Point(552, 16)
        Me.Button1.Name = "Button1"
        Me.Button1.Size = New System.Drawing.Size(128, 23)
        Me.Button1.TabIndex = 2
        Me.Button1.Text = "Load Calendar"
        '
        'Button2
        '
        Me.Button2.Location = New System.Drawing.Point(552, 48)
        Me.Button2.Name = "Button2"
        Me.Button2.Size = New System.Drawing.Size(128, 23)
        Me.Button2.TabIndex = 3
        Me.Button2.Text = "Update TnE"
        '
        'TimeGrid
        '
        Me.TimeGrid.DataMember = ""
        Me.TimeGrid.Location = New System.Drawing.Point(8, 72)
        Me.TimeGrid.Name = "TimeGrid"
        Me.TimeGrid.Size = New System.Drawing.Size(528, 280)
        Me.TimeGrid.TabIndex = 1
        '
        'Entry
        '
        Me.AutoScaleBaseSize = New System.Drawing.Size(5, 13)
        Me.ClientSize = New System.Drawing.Size(696, 358)
        Me.Controls.AddRange(New System.Windows.Forms.Control() {Me.Button2, Me.Button1, Me.TimeGrid, Me.GroupBox1})
        Me.Name = "Entry"
        Me.Text = "Entry"
        Me.GroupBox1.ResumeLayout(False)
        CType(Me.TimeGrid, System.ComponentModel.ISupportInitialize).EndInit()
        Me.ResumeLayout(False)

    End Sub

#End Region

    Private OutlookApp As Outlook.Application
    Private OutlookNamespace As Outlook.NameSpace
    Private CalendarInstance As Outlook.MAPIFolder

    Private TimeEntries As TnEService.TimeDS

    Private Enum TimeTypes
        Client = 1
        Personal = 2
        NonClient = 3
    End Enum

    Private Sub Entry_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load

        'get the current user
        Employee.Text = GetCurrentUser()

        'Default the start/end dates
        EndDate.Text = System.DateTime.Now.Today
        StartDate.Text = "10/10/2001" 'Change for demo only - System.DateTime.Now.AddDays(-5).ToShortDateString

    End Sub


    Private Sub Button1_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button1.Click
        'establish an outlook session
        EstablishSession()

        'load the T+E related entries from the calendar
        TimeGrid.DataSource = LoadTimeEntries(StartDate.Text, EndDate.Text).Time

    End Sub

    Private Sub Button2_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button2.Click
        'Create an instance of the TnEService.Time class
        Dim TnE As New TnEService.Time()

        'TODO: Add authentication logic

        'call the add method passing the TimeEntries dataset
        TimeEntries = TnE.Add(TimeEntries, False)

        MessageBox.Show("Time entries updated.", "OutlookBuddy .NET")
    End Sub

    Private Function GetCurrentUser() As String
        'return the currently logged in user's name
        Dim User As String = System.Security.Principal.WindowsIdentity.GetCurrent.Name

        Return User.Substring(User.LastIndexOf("\") + 1)

    End Function

    Private Sub EstablishSession()
        'create an app instance
        OutlookApp = New Outlook.Application()

        'get a reference to the namespace
        OutlookNamespace = OutlookApp.GetNamespace("MAPI")

        'get a reference to the Outlook Calendar
        CalendarInstance = OutlookNamespace.GetDefaultFolder(Outlook.OlDefaultFolders.olFolderCalendar)

    End Sub

    Private Function LoadTimeEntries(ByVal StartDate As DateTime, ByVal EndDate As DateTime) As TnEService.TimeDS
        Dim TimeEntry As TnEService.TimeDS.TimeRow
        'Dim TnETime As New TnEService.Time()
        Dim Filter As String
        Dim Appointments As Outlook.Items
        Dim Appointment As Outlook.AppointmentItem
        Dim i As Integer = 0

        'TimeEntries = TnETime.Create()
        TimeEntries = New TnEService.TimeDS()

        'TODO:
        'make sure everything is configured and grab the T+E categories

        'set the filter criteria
        Filter = "[Start] > '" & StartDate.AddDays(-1) & "' AND [End] < '" & EndDate.AddDays(1) & "'"

        'get the appointments
        Appointments = CalendarInstance.Items.Restrict(Filter)

        While i <= Appointments.Count
            Appointment = Appointments.GetNext

            'TODO: Filter on the T+E categories
            If Not Appointment Is Nothing Then
                If (InStr(Appointment.Categories, Categories.TnEClientCategory) > 0 Or _
                    InStr(Appointment.Categories, Categories.TnENonClientCategory) > 0 Or _
                    InStr(Appointment.Categories, Categories.TnEPersonalCategory) > 0) Then

                    'add the entry to the dataset
                    TimeEntry = TimeEntries.Time.NewTimeRow
                    With TimeEntry
                        .Employee = Employee.Text
                        .Calendar = Appointment.Start.ToShortDateString
                        .Start = Appointment.Start.ToShortTimeString
                        .Hours = Appointment.End.Subtract(Appointment.Start).TotalMinutes / 60
                        .TimeType = GetTimeType(Appointment.Categories)
                        If .TimeType = TimeTypes.Client Then
                            .Org = Appointment.Subject.Substring(0, 3)
                            .Project = Appointment.Subject.Substring(3, 3)
                            If Appointment.Subject.IndexOf("-") > 0 Then
                                .Task = Appointment.Subject.Substring(Appointment.Subject.IndexOf("-") + 1)
                            Else
                                .Task = 1
                            End If
                        Else
                            .Description = Appointment.Subject
                        End If
                    End With
                    TimeEntries.Time.AddTimeRow(TimeEntry)
                End If
            End If
            i += 1
        End While

        'return the dataset
        Return TimeEntries
    End Function

    Private Function GetTimeType(ByVal Category As String) As Integer
        Select Case Category
            Case Categories.TnEClientCategory
                Return TimeTypes.Client
            Case Categories.TnENonClientCategory
                Return TimeTypes.NonClient
            Case Categories.TnEPersonalCategory
                Return TimeTypes.Personal
        End Select
    End Function

End Class
